<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY dbns "http://docbook.org/ns/docbook">
]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="include.paths" select="1"/>
  <xsl:param name="include.copies" select="1"/>

  <xsl:template match="text/text()" name="initialize">
    <xsl:param name="text" select="."/>
    <xsl:param name="separator" select="' '"/>
    <xsl:choose>
      <xsl:when test="not(contains($text, $separator))">
        <xsl:value-of select="substring($text,1,1)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="substring(substring-before($text, $separator),1,1)"/>
        <xsl:call-template name="initialize">
          <xsl:with-param name="text" select="substring-after($text, $separator)"/>
          <xsl:with-param name="separator" select="$separator" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="text/text()" name="tag">
    <xsl:param name="tag" select="."/>
    <xsl:choose>
      <xsl:when test="not(tag)">DRAFT</xsl:when>
      <xsl:otherwise><xsl:value-of select="$tag" /></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
 
  <xsl:template match="log">
    <xsl:apply-templates select="logentry">
      <xsl:sort select="@revision" data-type="number" order="descending" />
    </xsl:apply-templates>
  </xsl:template>
  
  <xsl:template match="logentry">
    <!-- only match the first log entry in the sorted list -->
    <xsl:if test="position()=1">
      <releaseinfo id="_releaseinfo">
        <xsl:call-template name="tag">
          <xsl:with-param name="tag" select="tag" />
        </xsl:call-template>
        <xsl:value-of select="' '"/>
        <xsl:value-of select="concat('(',substring(@node,1,12),')')"/>
        <xsl:value-of select="' '"/>
        <xsl:value-of select="substring-before(date,'T')"/>
        <xsl:value-of select="' '"/>
        <xsl:call-template name="initialize">
          <xsl:with-param name="text" select="author" />
        </xsl:call-template>
      </releaseinfo>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>
