# frozen_string_literal: true

$LOAD_PATH.unshift '../lib'

require 'th_mauve'
require 'mauve/alert'
require 'mauve/alert_changed'
require 'mauve/configuration'
require 'mauve/configuration_builder'
require 'mauve/configuration_builders'
require 'mauve/notifiers'

# This test case ensures that reminders are sent according to Person's
# notification preferences (specifically their 'every X.hours' clause)
# This detects the bug reported by ian about being emailed every 15 mins
# despite having his settings at every 24.hours
class TcMauveSendsAlertsAccordingToUserPreferences < Mauve::UnitTest
  include Mauve
  def setup
    super
    setup_database
  end

  def teardown
    teardown_database
    super
  end

  def test_reminder_sends_alerts_according_to_user_preferences
    config = <<CONFIG
  server {
    use_notification_buffer false
  }

  notification_method("email") {
    debug!
    deliver_to_queue []
    disable_normal_delivery!
  }

  person("i_hate_notifications") {
    email "i_hate_notifications@example.com"
    all { email }

    notify {
      every 2000.hours
      during { true }
    }
  }

  person("i_love_notifications") {
    email "i_love_notifications@example.com"
    all { email }

    notify {
      every 1.seconds
      during { true }
    }
  }

  alert_group {
    level NORMAL
    notify('i_love_notifications', 'i_hate_notifications')
  }
CONFIG

    Configuration.current = ConfigurationBuilder.parse(config)
    notification_buffer = Configuration.current.notification_methods['email'].deliver_to_queue
    Server.instance.setup
    alert = Alert.new(source: 'test', alert_id: 'test_alert', summary: 'test alert')
    alert.raise!

    assert_equal(2, notification_buffer.length)

    Timecop.freeze(Time.now+10.minutes)
    AlertChanged.all.each{|ac| ac.poll; logger_pop}

    assert_equal(3, notification_buffer.length)

    Timecop.freeze(Time.now+2000.hours)
    AlertChanged.all.each{|ac| ac.poll; logger_pop}

    assert_equal(5, notification_buffer.length)

    alert.clear!

    assert_equal(7, notification_buffer.length)
  end
end
