$:.unshift "../lib"

require 'th_mauve'
require 'th_mauve_resolv'

require 'mauve/server'
require 'mauve/authentication'
require 'mauve/configuration'
require 'mauve/configuration_builder'
require 'mauve/configuration_builders'

require 'minitest/autorun'
require 'minitest/mock'

require 'net/ldap'

class TcMauveAuthentication < Mauve::UnitTest
  include Mauve

  def setup
    super
    setup_database

    config = <<EOF
failed_login_delay 0

ldap_auth_url 'ldaps://example.co.uk:636/dc=example,dc=co,dc=uk'
ldap_auth_group 'cn=Staff, ou=Groups, dc=example, dc=co, dc=uk'

person ("test") { }
EOF

    Configuration.current = ConfigurationBuilder.parse(config)
    Server.instance.setup
  end

  def teardown
    teardown_database
    super
  end

  def test_successful_auth
    # stub ldap
    Net::LDAP.stub :new, ldap_stub(:success) do
      assert(Authentication.authenticate('test', 'password'))
    end
  end

  def test_auth_fail
    # User has ldap permissions but is not in the group
    Net::LDAP.stub :new, ldap_stub(:not_in_group) do
      assert(!Authentication.authenticate('test', 'password'))
      assert_match(/test is not in the staff group/, logger_shift)
    end

    # ldap returns an error
    Net::LDAP.stub :new, ldap_stub(:random_error) do
      assert(!Authentication.authenticate('test', 'password'))
      assert_match(/Authentication for test failed: No Such Attribute/, logger_shift)
    end

    # users password is incorrect
    Net::LDAP.stub :new, ldap_stub(:invalid_credentials) do
      assert(!Authentication.authenticate('test', 'password'))
      assert_match(/Authentication for test failed: Invalid Credentials/, logger_shift)
    end
  end

  def test_invalid_auth
    # login is not a string
    assert(!Authentication.authenticate(1234, 'password'))
    assert_match(/Login must be a string/, logger_shift)

    # password is not a string
    assert(!Authentication.authenticate('test', true))
    assert_match(/Password must be a string/, logger_shift)

    # password is empty
    assert(!Authentication.authenticate('test', ''))
    assert_match(/Login or\/and password is\/are empty/, logger_shift)

    # login is empty
    assert(!Authentication.authenticate('', 'password'))
    assert_match(/Login or\/and password is\/are empty/, logger_shift)
  end
end
