#!/usr/bin/ruby

require 'pp'
require 'test/unit'


class TestHpacucliWrapper < Test::Unit::TestCase

  #
  # The -n flag means "noop" for testing.
  #
  CMD = "./hpacucli_wrapper -n"

  def setup

    controller_targets = %w(all slot=1)
    array_targets = %w(all A)
    pd_targets = %w(all allunassigned)
    ld_targets = %w(all 1)

    controller_words = %w(ctrl controller)
    array_words = %w(array)
    pd_words = %w(physicaldrive pd)
    ld_words = %w(logicaldrive ld)

    @controller_targets = []
    @other_targets = []

    controller_words.each do |cw|
      controller_targets.each do |ct|
        @controller_targets << [cw, ct].join(" ")
        array_words.each do |w|
          array_targets.each { |t| @other_targets << [cw, ct, w, t] }
        end
        pd_words.each do |w|
          pd_targets.each { |t| @other_targets << [cw, ct, w, t] }
        end
        ld_words.each do |w|
          ld_targets.each { |t| @other_targets << [cw, ct, w, t] }
        end
      end
    end
  end

  def test_command_length
    cmd = 512
    # make sure we can fit a command of at least 512 characters in
    `#{CMD} ctrl slot=#{"1"*cmd} show`
    # Make sure we get "not understood" for each command
    assert_equal(0, $? >> 8, "long command returned wrong code")
  end

  def test_permitted_commands
    controller_commands = [
      "show ssp",
      "show config",
      "show config detail" ]

    generic_commands = [
      "show",
      "show detail",
      "show status"
    ]
    
    commands = []

    @controller_targets.each do |ct|
      (controller_commands + generic_commands).each do |cc|
        commands << [ct, cc].join(" ")
      end
    end

    @other_targets.each do |ot|
      generic_commands.each { |gc| commands << [ot, gc].join(" ") }
    end

    commands.each do |cmd|
      err = `#{CMD} #{cmd} 2>&1`
      # Make sure we don't get "not understood" or "too long" for each command
      assert_equal(0, $? >> 8, "#{cmd}: returned #{$? >> 8}: #{err}")
    end
  end

  def test_illegal_commands
    bad_commands = %w( add create delete modify remove diag help )
    commands = []

    (@controller_targets + @other_targets).each do |t|
      bad_commands.each do |c|
        cmd = [t, c].join(" ")
        err = `#{CMD} #{cmd} 2>&1`
        # Make sure we get "not understood" for each command
        assert_equal(4, $? >> 8, "#{cmd} returned #{$? >> 8}: #{err}")
      end
    end
  end
end

