load "../sbin/bytemark-healthcheck"

require 'minitest/autorun'

class TestScheduling < Minitest::Test

  def run_tests(start, intervals, directories, label_format)
    last_run = {}

    intervals.each do |interval|
      if interval.is_a?(Array)
        now = interval[1]
        interval = interval[0]
      else
        arg = now = start+interval
      end

      h = HealthcheckDriver.new(".",".",Time.at(now*60))
      print label_format % interval if $VERBOSE
      directories.each do |directory|
        should_run = h.should_run?(directory)
        print should_run ? "x" : " " if $VERBOSE
        print (directory % 5 == 0) ? "|" : "" if $VERBOSE
        next unless should_run

        unless last_run[directory].nil?
          assert_equal(directory, now - last_run[directory])
        end
        last_run[directory] = now
      end
      print "\n" if $VERBOSE
      print "-"*80 + "\n" if $VERBOSE and interval.is_a?(Numeric) and interval % 5 == 0
    end

  end

  def test_select_by_time

    start = (Time.at(1429336800).to_f/60.0).floor

    puts "Start time is #{Time.at(start*60)}" if $VERBOSE

    run_tests(start, (0..180), (1..60), "t+%-3i ")

  end

  def test_select_by_int

    last_run = {}
    start = 0

    if $VERBOSE
      puts "directories are on the x axis, in groups of 5"
      puts "interval are on the y axis"
      puts "An x means jobs in that directory will be run"
    end

    run_tests(start, (0..180), (1..60), "%3i ")

  end

  def test_select_by_name
    return

    last_run = {}
    start = 0

    if $VERBOSE
      puts "directories are on the x axis, in groups of 5"
      puts "interval are on the y axis"
      puts "An x means jobs in that directory will be run"
    end

    intervals = [
      ["all", 1],
      ["hourly", 60],
      ["daily", 60*24],
      ["weekly", 60*24*7],
      ["monthly", 60*24*30]
    ]

    run_tests(start, intervals, [1,60,60*24,60*24*7,60*24*30], "%10s ")

  end

end
