require 'minitest/autorun'
require 'tempfile'
load "../sbin/bytemark-healthcheck"

class TestStateFile < Minitest::Test

  def setup
    #
    # Disables the actual sending of alerts.
    #
    ENV["NOP"] = "NOP"

    @state = Tempfile.new('state')
  end

  def teardown
    if @state
      @state.close
      @state.unlink
    end
  end

  def test_can_read
    now = Time.now

    x = HealthcheckDriver.new(".",@state.path, now)
    x.load_previous
    assert(x.alerts.empty?, "A driver with no previous state should have no alerts")
    assert(x.failures.empty?, "A driver with no previous state should have no failures")
    x.update_state

    y = HealthcheckDriver.new(".",@state.path, now)
    y.load_previous
    assert(y.alerts.empty?, "The recorded state should have no alerts")
    assert(y.failures.empty?, "The recorded state should have no failures")

    # Now do a basic test for failures
    alert = {:timestamp => now.to_i, :filename => '/path/to/this/job', :ttl => 5}
    failure = "This test failed for some reason"
    x.alerts << alert
    x.failures[alert[:filename]] = failure
    x.update_state

    y.load_previous

    [:timestamp, :filename, :ttl].each do |f|
      assert_equal(alert[f], y.alerts.first[f])
    end
    assert_equal(failure, y.failures[alert[:filename]])
  end

end
