#!/usr/bin/ruby
require 'minitest/autorun'
require 'minitest/unit'
require 'mocha/mini_test'
load '../sbin/bytemark-healthcheck'

class TestExceptionHandling < Minitest::Test
  def setup
    #
    # Disables the actual sending of alerts.
    #
    ENV['NOP'] = 'NOP'

    # Create a mocked directory, globs etc for the tests.  This is probably a
    # bit brittle.
    @dir = '/some/faux/directory'

    # Stub out File#lstat everywhere.
    File.stubs(:lstat).returns(
      stub('file_lstat',
           :directory? => true, :file? => true, :executable? => true)
    )

    # And stub out Dir#glob
    job_dir = File.join(@dir, '30')
    Dir.stubs(:glob).with(@dir + '/*').returns([job_dir])

    job = File.join(job_dir, 'foo.rb')
    Dir.stubs(:glob).with(job_dir + '/*').returns([job])
  end

  #
  # Test that when run_job raises an exception `run_parts`, notices that and
  # `run` doesn't die.
  #
  def test_handling_in_run_job
    now = Time.now
    h = HealthcheckDriver.new(@dir, '.', now)

    #
    # This should raise an exception, because the job has been mocked, and
    # therefore does not exist.
    #
    h.run(1)

    # We should have one failure.
    assert_equal(1, h.failures.keys.length, 'Wrong number of failures')

    # Because the test didn't complete we'll have zero alerts.
    #
    # (In the real-code `raise_alerts` will generate an alert from failures).
    #
    assert_equal(0, h.alerts.length, 'Wrong number of alerts')
  end
end
