require 'minitest/autorun'
load "../sbin/bytemark-healthcheck"

class TestHeartbeats < Minitest::Test

  def setup
    #
    # Disables the actual sending of alerts.
    #
    ENV["NOP"] = "NOP"

  end

  def test_heartbeat
    now = Time.now
    h = HealthcheckDriver.new(".",".", now)
    update = h.raise_alerts

    # Should only have one heartbeat.
    assert_equal(2, update.alert.length, 'Incorrect number of alerts being sent')

    heartbeat = update.alert.first
    assert_equal("-heartbeat", heartbeat.id, "heartbeat ID is not '-heartbeat'")
    assert_equal(now.to_i, heartbeat.clear_time, "Heartbeat not set to clear 'now'")
    assert((now.to_i+120..now.to_i+900).include?(heartbeat.raise_time), "Heartbeat raise time out of a sane range (2-15 mins)")
    assert_match(/heartbeat/, heartbeat.summary, "The word 'heartbeat' not found in summary")
    assert_match(/heartbeat/, heartbeat.detail, "The word 'heartbeat' not found in detail")
  end


  def test_heartbeat_clear
    now = Time.now
    h = HealthcheckDriver.new(".",".", now)
    update = h.clear_alerts

    # Should only have one heartbeat.
    assert_equal(1, update.alert.length, 'Incorrect number of alerts being sent')

    heartbeat = update.alert.first
    assert_equal("-heartbeat", heartbeat.id, "heartbeat ID is not 'heartbeat'")
    assert_equal(now.to_i, heartbeat.clear_time, "Heartbeat not set to clear 'now'")
    assert_equal(0,heartbeat.raise_time, "Heartbeat raise time is not empty")
    assert_match(/heartbeat/, heartbeat.summary, "The word 'heartbeat' not found in summary")
    assert_match(/heartbeat/, heartbeat.detail, "The word 'heartbeat' not found in detail")
  end

  def test_failed_alerts
    now = Time.at(1234567890)
    h = HealthcheckDriver.new("test_heartbeats/fail/",".", now)
    h.run(1)

    update = h.raise_alerts
    assert_equal(3, update.alert.length, "Expected 2 alerts in the update (heartbeat + healthcheck)")

    # The healthcheck is added after the heartbeat
    healthcheck = update.alert.last

    assert_equal("-healthcheck-failures", healthcheck.id, "healthcheck ID is not 'healthcheck-failures'")
    assert_equal(0, healthcheck.clear_time, "Healthcheck is set to clear..?")
    assert_equal(now.to_i, healthcheck.raise_time, "Healthcheck is not set to raise immediately raise")
    assert_match(/health ?check/i, healthcheck.summary, "The word 'healthcheck' not found in summary")
    assert_match(/test_heartbeats\/fail\/1\/fail/, healthcheck.detail, "The failing script not found in detail")

  end

end
