
#
#  This class either a) returns the output of running commands, or
# b) returns the output from a faked command
#
module Bytemark
  module Healthcheck
    class CommandWrapper
      def self.run_command(str)
        if ENV['TEST'] && ENV['TEST_PREFIX']
          #
          #  Count the number of commands we've executed so far.
          #
          count = ENV['TEST_COUNT'] || '0'
          count = count.to_i
          ENV['TEST_COUNT'] = (count + 1).to_s

          #
          #  Read the output from the faked file.
          #
          #    $prefix/$count.cmd
          #
          file = "#{ENV['TEST_PREFIX']}/#{count}.cmd"
          File.read(file)
        else
          `#{str}`
        end
      end
    end
  end
end
