/* this is a wrapper for tw_cli */

#include "tw_cli_wrapper.h"

int
main (int argc, char **argv)
{

  regex_t *cmd_regex;
  char *cmd, tw_cli_cmd[1024];
  int c, exit_code = -1;
  int dry_run = 0;

  if(argc < 2) {
    fprintf(stdout, "Usage: tw_cli_wrapper [-n] <3Ware CLI commands>\n");
    exit(1);
  }

  // This matches if argv[1] contains "-n"
  if(*argv[1] == '-' && *(argv[1]+1) == 'n') {
    dry_run = 1;
  }

  // concatenate the arguments by overwriting the null at the end of each with
  // a space
  for (c=1+dry_run; c<argc; c++)
    *(argv[c]-1)=32;

  cmd = argv[1+dry_run];

  // allocate memory for the regex
  cmd_regex = (regex_t *) malloc(sizeof(regex_t));

  // Check it has been allocated
  if( cmd_regex == NULL ) {
    fprintf(stderr,"Unable to allocate memory\n");
    exit(5);
  }

  // compile the regex
  regcomp (cmd_regex, CMD_REGEX, REG_NOSUB | REG_EXTENDED);

  // perform the comparison
  if(regexec(cmd_regex, cmd, 0, NULL, 0) == 0) {

    // print the command to tw_cli_cmd
    if(snprintf(tw_cli_cmd,sizeof(tw_cli_cmd),"%s %s",TW_CLI,cmd) >= sizeof(tw_cli_cmd)) {
      fprintf(stderr,"Command too long (%lu): %s\n", sizeof(&cmd), cmd);
      exit_code = 2;

    } else {
      // Set an explicit null character at the end of the command string
      tw_cli_cmd[sizeof(tw_cli_cmd)-1] = 0;

      if(dry_run == 1) {
        fprintf(stdout,"Dry run: %s\n", tw_cli_cmd);
        exit_code = 0;

      } else if(setreuid(0,0) == 0) {
        exit_code = system(tw_cli_cmd);
  
      } else {
        fprintf(stderr,"Cannot setreuid to root: permission denied\n");
        exit_code = 3;
      }

    }

  } else {
    fprintf(stderr,"Command not understood: %s\n",cmd);
    exit_code = 4;

  }

  // free up any memory used by the regex
  regfree (cmd_regex); free(cmd_regex);

  // The end.  My friend.  
  exit (exit_code);

}


