#!/usr/bin/ruby

require 'pp'
require 'test/unit'


class TestTwCliWrapper < Test::Unit::TestCase

  CMD = "./tw_cli_wrapper -n"

  def test_command_length
    # FIXME need to test this.
#    cmd = 512
#    # make sure we can fit a command of at least 512 characters in
#    `#{CMD} /c#{"1"*cmd} show`
#    # Make sure we get "not understood" for each command
#    assert_equal(0, $? >> 8, "long command returned wrong code")
  end

  def test_permitted_commands
      [ "show", 
        "/c0 show", 
        "/c99 show all", 
        "/c0 show numunits", 
        "/c0 show numdrives", 
        "/c99 show numports", 
        "/c0/u0 show", 
        "/c99/u99 show all", 
        "/c0/p0 show", 
        "/c99/p99 show all", 
        "/c0/bbu show", 
        "/c0/bbu show all", 
        "/c0/e0 show", 
        "/c99/e99 show all" ].each do |cmd| 
      err = `#{CMD} #{cmd} 2>&1`
      # Make sure we get "not understood" for each command
      assert_equal(0, $? >> 8, "#{cmd} returned #{$? >> 8}: #{err}")
    end

  end

  def test_illegal_commands
    # TODO: add all commands.
    [
      # Primary commands
      "focus //elvis.amcc.com",
      "update fw=/tmp/prom0006.img",
      "update fw=/tmp/prom0006.img force",
      # Controller commands
      "/c0 add rebuild=sun:16:3",
      "/c0 add selftest=Sun:16",
      "/c0 add type=raid0 disk=0-1 vol=45:20:50:12",
      "/c0 add type=raid5 disk=0:2:3 rapidrecovery=all",
      "/c0 add type=raid5 disk=2-5 v0=10",
      "/c0 add type=raid5 disk=2-5 vol=100:30:2:45",
      "/c0 add verify=sun:15:4",
      "/c0 add verify=sun:23:2",
      "/c0 commit",
      "/c0 del verify=3",
      "/c0 flush",
      "/c0 rescan",
      "/c0 set autocarve=on",
      "/c0 set autodetect=off disk=3:5-6",
      "/c0 set autodetect=off disk=all",
      "/c0 set autorebuild=on",
      "/c0 set carvesize=2000",
      "/c0 set dpmstat=off",
      "/c0 set rebuildmode=lowlatency",
      "/c0 set rebuildrate=2",
      "/c0 set verify=advanced",
      "/c0 set verify=basic pref=Fri:23",
      "/c0 set verifymode=lowlatency",
      "/c0 set verifyrate=2",
      "/c0 update fw=/tmp/prom0006.img",
      # Unit commands
      "/c0/u0 del",
      "/c0/u0 del noscan",
      "/c0/u0 del quiet",
      "/c0/u0 del quiet noscan",
      "/c0/u0 migrate type=raid10 disk=10-11 stripe=16",
      "/c0/u0 migrate type=single",
      "/c0/u0 pause",
      "/c0/u0 pause rebuild",
      "/c0/u0 remove",
      "/c0/u0 remove noscan",
      "/c0/u0 remove noscan quiet",
      "/c0/u0 remove quiet",
      "/c0/u0 resume",
      "/c0/u0 resume rebuild",
      "/c0/u0 set autoverify=on",
      "/c0/u0 set identify=on",
      "/c0/u0 set qpolicy = on",
      "/c0/u0 set rapidrecovery=all",
      "/c0/u0 set rapidrecovery=disable",
      "/c0/u0 set rapidrecovery=disable quiet",
      "/c0/u0 set rapidrecovery=rebuild",
      "/c0/u0 set rdcache=intelligent",
      "/c0/u0 set storsave=protect",
      "/c0/u0 start rebuild",
      "/c0/u0 start verify",
      "/c0/u0 stop rebuild",
      "/c0/u0 stop verify",
      # Port commands
      "/c0/p0 set dpmstat=clear type=ext",
      "/c0/p0 set dpmstat=clear type=ra",
      "/c0/p0 set dpmstat=clear type=ra",
      "/c0/p0 set identify=on",
      "/c0/p0 remove",
      # BBU commands
      "/c0/bbu test",
      "/c0/bbu enable",
      "/c0/bbu disable",
      # Enclosure commands
      "/c0/e0 update fw=/tmp/prom0006.img",
      "/c0/e0/alm0 set alarm=unmute",
      "/c0/e0/fan1 set identify=on",
      "/c0/e0/fan1 set speed=1",
      "/c0/e0/pwrs1 set identify=on",
      "/c0/e0/slot1 set identify=on",
      "/c0/e0/temp1 set identify=on",
      # Phy object commands
      "/c0/phy0 set link=1.5",
    ].each do |cmd|
      err = `#{CMD} #{cmd.chomp} 2>&1`
      # Make sure we get "not understood" for each command
      assert_equal(4, $? >> 8, "#{cmd} returned #{$? >> 8}: #{err}")
    end
  end
end

